Option Explicit
Const scriptName = "Reveal File of Graphic"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - November 1, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a single selected graphic element."
Const errNoShell = "The script couldn't create a WScript.Shell object."

Const kRunStart = "explorer /select,"""
Const kRunEnd = """"


' Enums
Const crElmGraphic = 1197688172




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

Dim sel, theElem
If errNum = 0 Then
  On Error Resume Next

  Set sel = CreatorApp.Selection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum = 0 Then
    If (sel.Count <> 1) Then
      errNum = -1
    Else
      Set theElem = sel(1)
      If (theElem.Class <> crElmGraphic) Then
        errNum = -1
      End If
    End If
  End If
End If

If errNum = 0 Then
  Dim itsPath
  itsPath = theElem.File
  itsPath = kRunStart & itsPath & kRunEnd

  On Error Resume Next
  Dim shell
  Set shell = WScript.CreateObject("WScript.Shell")
  If Err.Number = 0 Then
    Call shell.Run(itsPath, 1, False)
  Else
    Call MsgBox(errNoShell, vbOKOnly, scriptName)
  End If
  On Error Goto 0
Else
    Call MsgBox(errNoSelection, vbOkonly, scriptName)	
End If
